/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.tracking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.sonarlint.eclipse.core.internal.tracking.Input;
import org.sonarlint.eclipse.core.internal.tracking.Trackable;
import org.sonarlint.eclipse.core.internal.tracking.Tracking;

public class Tracker<RAW extends Trackable, BASE extends Trackable> {
    public Tracking<RAW, BASE> track(Input<RAW> rawInput, Input<BASE> baseInput) {
        Tracking<RAW, BASE> tracking = new Tracking<RAW, BASE>(rawInput, baseInput);
        this.match(tracking, LineAndLineHashKeyFactory.INSTANCE);
        this.match(tracking, LineHashAndMessageKeyFactory.INSTANCE);
        this.match(tracking, LineAndMessageKeyFactory.INSTANCE);
        this.match(tracking, LineHashKeyFactory.INSTANCE);
        return tracking;
    }

    private void match(Tracking<RAW, BASE> tracking, SearchKeyFactory factory) {
        if (tracking.isComplete()) {
            return;
        }
        HashMap baseSearch = new HashMap();
        for (Trackable base : tracking.getUnmatchedBases()) {
            SearchKey searchKey = factory.create(base);
            if (!baseSearch.containsKey(searchKey)) {
                baseSearch.put(searchKey, new ArrayList());
            }
            ((List)baseSearch.get(searchKey)).add(base);
        }
        for (Trackable raw : tracking.getUnmatchedRaws()) {
            SearchKey rawKey = factory.create(raw);
            Collection bases = (Collection)baseSearch.get(rawKey);
            if (bases == null || bases.isEmpty()) continue;
            Trackable match = (Trackable)bases.iterator().next();
            tracking.match(raw, match);
            ((List)baseSearch.get(rawKey)).remove(match);
        }
    }

    private static class LineAndLineHashKey
    implements SearchKey {
        private final String ruleKey;
        private final Integer lineHash;
        private final Integer line;

        LineAndLineHashKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.line = trackable.getLine();
            this.lineHash = trackable.getLineHash();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            LineAndLineHashKey that = (LineAndLineHashKey)o;
            return Objects.equals(this.line, that.line) && Objects.equals(this.lineHash, that.lineHash) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + (this.lineHash != null ? this.lineHash.hashCode() : 0);
            result = 31 * result + (this.line != null ? this.line.hashCode() : 0);
            return result;
        }
    }

    private static enum LineAndLineHashKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey create(Trackable t) {
            return new LineAndLineHashKey(t);
        }
    }

    private static class LineAndMessageKey
    implements SearchKey {
        private final String ruleKey;
        private final String message;
        private final Integer line;

        LineAndMessageKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.message = trackable.getMessage();
            this.line = trackable.getLine();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            LineAndMessageKey that = (LineAndMessageKey)o;
            return Objects.equals(this.line, that.line) && this.message.equals(that.message) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + this.message.hashCode();
            result = 31 * result + (this.line != null ? this.line.hashCode() : 0);
            return result;
        }
    }

    private static enum LineAndMessageKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey create(Trackable t) {
            return new LineAndMessageKey(t);
        }
    }

    private static class LineHashAndMessageKey
    implements SearchKey {
        private final String ruleKey;
        private final String message;
        private final Integer lineHash;

        LineHashAndMessageKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.message = trackable.getMessage();
            this.lineHash = trackable.getLineHash();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            LineHashAndMessageKey that = (LineHashAndMessageKey)o;
            return Objects.equals(this.lineHash, that.lineHash) && this.message.equals(that.message) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + this.message.hashCode();
            result = 31 * result + (this.lineHash != null ? this.lineHash.hashCode() : 0);
            return result;
        }
    }

    private static enum LineHashAndMessageKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey create(Trackable t) {
            return new LineHashAndMessageKey(t);
        }
    }

    private static class LineHashKey
    implements SearchKey {
        private final String ruleKey;
        private final Integer lineHash;

        LineHashKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.lineHash = trackable.getLineHash();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            LineHashKey that = (LineHashKey)o;
            return Objects.equals(this.lineHash, that.lineHash) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + (this.lineHash != null ? this.lineHash.hashCode() : 0);
            return result;
        }
    }

    private static enum LineHashKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey create(Trackable t) {
            return new LineHashKey(t);
        }
    }

    private static interface SearchKey {
    }

    private static interface SearchKeyFactory {
        public SearchKey create(Trackable var1);
    }
}

